
#include "sample1.h"

/*********************************************************************************
 *
 * File:           SAMPLE1.C
 *
 * Description:    Sample program for SOLID Light Client API
 *
 * Author:         SOLID / ATH
 * Date:           1997-11-18
 *
 * 
 * SOLID Light Client sample program does the following. 
 *
 * 1. Checks that there are enough input parameters to contain sufficient 
 *    connect information
 * 2. Prepares to connect SOLID Server throught Light Client by allocating 
 *    memory for HENV and HDBC objects 
 * 3. Connects to SOLID Server using Light Client Library 
 * 4. Creates a statement for one query, 
 *    'SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM TABLES' for reading 
 *    data from one of SOLID Server's system tables. 
 * 5. Executes the query 
 * 6. Fetches and outputs all the rows of a result set. 
 * 7. Closes the connection gracefully.
 *  
 *
 **********************************************************************************/
void __cdecl main(int argc, char *argv[])
{
  HENV henv;      /* pointer to environment object            */ 
  HDBC hdbc;      /* pointer to database connection object    */ 
  RETCODE rc;     /* variable for return code                 */ 
  HSTMT hstmt;    /* pointer to database statement object     */ 
  char buf[255];  /* buffer for data to be obtained from db   */
  char buf2[255]; /* buffer for a printable row to be created */
  int iCount = 0; /* counter for rows to be fetched.          */


  /* 1. Checks that there are enough input parameters to contain sufficient */
  /*    connect information                                                 */
  if (argc != 4)
  {
    printf("Proper usage \"connect string\" uid pwd \n");
    printf("argc %i \n",argc);
    return;
  }
  printf("Will connect SOLID Server at %s with uid %s and pwd %s.\n",argv[1],argv[2],argv[3]);
  

  /* 2. Prepares to connect SOLID Server throught Light Client by allocating */
  /*    memory for HENV and HDBC objects                                     */

  rc = SQLAllocEnv(&henv); 
  if (SQL_SUCCESS != rc) 
  { 
    printf("SQLAllocEnv fails.\n"); 
    return; 
  } 
  
  rc = SQLAllocConnect(henv,&hdbc); 
  if (SQL_SUCCESS != rc) 
  { 
    printf("SQLAllocConnect fails.\n"); 
    return; 
  } 

  /* 3. Connects to SOLID Server using Light Client Library                   */
  rc = SQLConnect(hdbc,(UCHAR*)argv[1],SQL_NTS, (UCHAR*)argv[2],SQL_NTS, (UCHAR*)argv[3], SQL_NTS); 
  if (SQL_SUCCESS != rc) 
  { 
    printf("SQLConnect fails.\n"); 
    return;   
  } 
  else printf("Connect ok.\n");


  /* 4. Creates a statement for one query,                                   */
  /*    'SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM TABLES' for reading  */
  /*    data from one of SOLID Server's system tables.                       */

  rc = SQLAllocStmt(hdbc, &hstmt); 
  if (SQL_SUCCESS != rc) { 
    printf("SQLAllocStmt failed. \n"); 
   } 
  
  rc = SQLPrepare(hstmt,(UCHAR*)"SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM TABLES",SQL_NTS); 
  
  if (SQL_SUCCESS != rc) { 
    printf("SQLPrepare failed. \n"); 
  } 
  else printf("SQLPrepare succeeded. \n");


  /* 5. Executes the query                                                   */
  rc = SQLExecute(hstmt); 
  if (SQL_SUCCESS != rc) { 
    printf("SQLExecute failed. \n"); 
  } 
  else printf("SQLExecute succeeded. \n");
  

  /* 6. Fetches and outputs all the rows of a result set.                    */
  rc = SQLFetch(hstmt); 
  if ((SQL_SUCCESS != rc) && (SQL_NO_DATA_FOUND != rc)) { 
    printf("SQLFetch returned an unexpected error code . \n"); 
  } 
  else printf("Starting to fetch data.\n");
  
  while (SQL_NO_DATA_FOUND != rc) 
  { 
    iCount++;
    sprintf(buf2,"Row %i :",iCount);
    
    rc = SQLGetCol(hstmt,1,SQL_C_CHAR,buf,sizeof(buf),NULL); 
    if (SQL_SUCCESS == rc) 
    { 
      strcat(buf2,buf);
      strcat(buf2,",");
    } 
    else printf("Error in SQL_GetCol(1) \n"); 

    rc = SQLGetCol(hstmt,2,SQL_C_CHAR,buf,sizeof(buf),NULL); 
    if (SQL_SUCCESS == rc) 
    { 
      strcat(buf2,buf);
      strcat(buf2,",");
    } 
    else printf("Error in SQL_GetCol(2) \n"); 

    rc = SQLGetCol(hstmt,3,SQL_C_CHAR,buf,sizeof(buf),NULL); 
    if (SQL_SUCCESS == rc) 
    { 
      strcat(buf2,buf);
    } 
    else printf("Error in SQL_GetCol(3) \n"); 

    printf("%s \n",buf2);

  
    rc = SQLFetch(hstmt); 
  } 
  
  rc = SQLFreeStmt(hstmt,SQL_DROP); 
  if ((SQL_SUCCESS != rc)) 
  { 
    printf("SQLFreeStmt failed. "); 
  } 

  /* 7. Closes the connection gracefully.                          */
  SQLDisconnect(hdbc); 
  SQLFreeConnect(hdbc); 
  SQLFreeEnv(henv);

  printf("Sample program ends successfully.\n");

}


