/****************************************************************\
**  file         * cli0lcli.h
**		 *
**  description  * SOLID Light Client functions
**		 *
**		 * For the reference documentation of SOLID Light 
**		 * Client API, please see file lclimethods.htm 
**		 *
**  copyright 	(C) Solid Information Technology Ltd 1997
\****************************************************************/

/* Summary of SOLID Light Client functions

Connecting to a Data Source
	SQLAllocEnv	 Obtains an environment handle. One 
			 environment handle is used for one or
			 more connections.
	SQLAllocConnect	 Obtains a connection handle.
	SQLConnect	 Connects to a specific SOLID Server with
			 listen name, user ID, and password.

Preparing SQL Requests
	SQLAllocStmt	 Allocates a statement handle.
	SQLPrepare	 Prepares an SQL statement for later 
			 execution.
	SQLSetParamValue Gives values to parameters in a prepared
			 SQL statement
	SQLGetCursorName Returns cursor name associated with a 
			 statement handle.
	SQLSetCursorName Specifies a cursor name.

Submitting Requests
	SQLExecute	 Executes a prepared statement.
	SQLExecDirect	 Executes a statement.

Retrieving Results and Information about Results
	SQLRowCount	 Returns the number of rows affected by 
			 an insert, update or delete request.
	SQLNumResultCols Returns the number of columns in the 
			 result set.
	SQLDescribeCol	 Describes a column in the result set.
	SQLFetch	 Moves to the next row in the result set
	SQLGetCol	 Retrieve column data from the current row
			 in the result set into a C variable
	SQLGetData	 Retrieve column data from the current row
			 in the result set into a C variable
	SQLError	 Returns additional error or status 
			 information.

Terminating a Statement
	SQLFreeStmt	 Ends statement processing and closes the 
			 associated cursor, discards pending 
			 results, and, optionally frees all 
			 resources associated with the statement
			 handle.
	SQLTransact	 Commits or rolls back a transaction.

Terminating a Connection
	SQLDisconnect	 Closes the connection.
	SQLFreeConnect	 Releases the connection handle.
	SQLFreeEnv	 Releases the environment handle.
*/ 


#ifndef CLI0LCLI_H
#define CLI0LCLI_H

#include "cli0env.h"
#include "cli0defs.h"

RETCODE SQLAllocEnv(
        HENV* phenv);

RETCODE SQLFreeEnv(
        HENV henv);

RETCODE SQLAllocConnect(
        HENV henv,
        HDBC* phdbc);

RETCODE SQLFreeConnect(
        HDBC hdbc);

RETCODE SQLConnect(
        HDBC hdbc,
        UCHAR* szDSN,
        SWORD cbDSN,
        UCHAR* szUID,
        SWORD cbUID,
        UCHAR* szAuthStr,
        SWORD cbAuthStr);

RETCODE SQLDisconnect(
        HDBC hdbc);

RETCODE SQLAllocStmt(
        HDBC hdbc,
        HSTMT* phstmt);

RETCODE SQLFreeStmt(
        HSTMT hstmt,
        UWORD fOption);

RETCODE SQLPrepare(
        HSTMT hstmt,
        UCHAR* szSqlStr,
        SDWORD cbSqlStr);

RETCODE SQLSetParamValue(
        HSTMT hstmt,
        UWORD ipar,
        SWORD fCType,
        SWORD fSqlType,
        UDWORD cbColDef,
        SWORD ibScale,
        PTR rgbValue,
        SDWORD* pcbValue);

RETCODE SQLSetCursorName(
        HSTMT hstmt,
        UCHAR* szCursor,
        SWORD cbCursor);

RETCODE SQLGetCursorName(
        HSTMT hstmt,
        UCHAR* szCursor,
        SWORD cbCursorMax,
        SWORD* pcbCursor);

RETCODE SQLExecute(
        HSTMT hstmt);

RETCODE SQLExecDirect(
        HSTMT hstmt,
        UCHAR* szSqlStr,
        SDWORD cbSqlStr);

RETCODE SQLNumResultCols(
        HSTMT hstmt,
        SWORD* pccol);

RETCODE SQLDescribeCol(
        HSTMT hstmt,
        UWORD icol,
        UCHAR* szColName,
        SWORD cbColNameMax,
        SWORD* pcbColName,
        SWORD* pfSqlType,
        UDWORD* pcbColDef,
        SWORD* pibScale,
        SWORD* pfNullable);

RETCODE SQLFetch(
        HSTMT hstmt);

RETCODE SQLGetData(
        HSTMT hstmt,
        UWORD icol,
        SWORD fCType,
        PTR rgbValue,
        SDWORD cbValueMax,
        SDWORD* pcbValue);

RETCODE SQLGetCol(
        HSTMT hstmt,
        UWORD icol,
        SWORD fCType,
        PTR rgbValue,
        SDWORD cbValueMax,
        SDWORD* pcbValue);

RETCODE SQLRowCount(
        HSTMT hstmt,
        SDWORD* pcrow);

RETCODE SQLTransact(
        HENV henv,
        HDBC hdbc,
        UWORD fType);

RETCODE SQLError(
        HENV henv,
        HDBC hdbc,
        HSTMT hstmt,
        UCHAR* szSqlState,
        SDWORD* pfNativeError,
        UCHAR* szErrorMsg,
        SWORD cbErrorMsgMax,
        SWORD* pcbErrorMsg);

#endif /* CLI0LCLI_H */
