/**
 *      sample1 JDBC sample application
 *
 *      Sep 24 1997 JP
 *
 *      This simple JDBC application does the following using
 *      Solid native JDBC driver. 
 *  
 *  1. Registers the driver using JDBC driver manager services
 *  2. Prompts the user for a valid JDBC connect string
 *  3. Connects to Solid Server using the driver
 *  4. Creates a statement for one query, 
 *     'SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM TABLES'
 *     for reading data from one of Solid Server's system tables.
 *  5. Executes the query
 *  6. Fetches and dumps all the rows of a result set. 
 *  7. Closes connection
 *
 *  To build and run the application 
 *
 *  1. Make sure you have a working Java Development environment
 *  2. Install and start Solid Server to connect. Ensure that the Server 
 *     is up and running.
 *  3. Append SolidDriver.zip into the CLASSPATH definition used 
 *     by your development/running environment. 
 *  4. Create a java project based on the file sample1.java. 
 *  5. Build and run the application.
 * 
 *  For more information read the readme.htm file contained by
 *  SOLID JDBC Driver package.
 *
 */

import java.io.*;

public class sample1 {

    public static void main (String args[]) throws Exception
    {
        java.sql.Connection conn;
        java.sql.ResultSetMetaData meta;
        java.sql.Statement stmt;
        java.sql.ResultSet result;
        int i;
            
        System.out.println("JDBC sample application starts...");
        System.out.println("Application tries to register the driver.");

        // this is the recommended way for registering Drivers
        java.sql.Driver d = (java.sql.Driver)Class.forName("solid.jdbc.SolidDriver").newInstance();

        System.out.println("Driver succesfully registered.");

        // the user is asked for a connect string 
        System.out.println("Now sample application needs a connectstring in format:\n");
        System.out.println("jdbc:solid://<host>:<port>/<user name>/<password>\n");
        System.out.print("\nPlease enter the connect string >");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String sCon = reader.readLine();

        // next, the connection is attempted
        System.out.println("Attempting to connect :" + sCon);
        conn = java.sql.DriverManager.getConnection(sCon);

        System.out.println("SolidDriver succesfully connected.");

        String sQuery = "SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE FROM TABLES";

        stmt= conn.createStatement();
        
        result = stmt.executeQuery(sQuery);
        System.out.println("Query executed and result set obtained.");

        // we get a metadataobject containing information about the
        // obtained result set
        System.out.println("Obtaining metadata information.");
        meta = result.getMetaData();
        int cols = meta.getColumnCount();

        System.out.println("Metadata information for columns is as follows:");
        // we dump the column information about the result set
        for (i=1; i <= cols; i++)
        {
            System.out.println("Column i:"+i+"  "+meta.getColumnName(i)+ "," + meta.getColumnType(i) + "," + meta.getColumnTypeName(i));
        }

        // and finally, we dump the result set
        System.out.println("Starting to dump resultset.");
        int cnt = 1;
        while(result.next())
        {
            System.out.print("\nRow "+cnt+" : ");
            for (i=1; i <= cols; i++) {
                System.out.print(result.getString(i)+"\t");
            }
            cnt++;
        }
        
        stmt.close();

        conn.close();
        // and not it is all over
        System.out.println("\nResult set dumped. Sample application finishes.");
    }
}
