/**
 *      sample3 JDBC sample application
 *
 *      Sep 24 1997 JP
 *
 *      This simple JDBC application does the following using
 *      Solid native JDBC driver. 
 *  
 *  1. Registers the driver using JDBC driver manager services
 *  2. Prompts the user for a valid JDBC connect string
 *  3. Connects to Solid Server using the driver
 *  4. Drops and creates a procedure sample3. If the procedure
 *     does not exist dumps the related exception.
 *  5. Calls that procedure using java.sql.Statement
 *  6. Fetches and dumps all the rows of a result set. 
 *  7. Closes connection
 *
 *  To build and run the application 
 *
 *  1. Make sure you have a working Java Development environment
 *  2. Install and start Solid Server to connect. Ensure that the Server 
 *     is up and running.
 *  3. Append SolidDriver.zip into the CLASSPATH definition used 
 *     by your development/running environment. 
 *  4. Create a java project based on the file sample3.java. 
 *  5. Build and run the application.
 * 
 *  For more information read the readme.htm file contained by
 *  SOLID JDBC Driver package.
 *
 */

import java.io.*;
import java.sql.*;

public class sample3 {

    static Connection conn;
    public static void main (String args[]) throws Exception
    {
        System.out.println("JDBC sample application starts...");
        System.out.println("Application tries to register the driver.");

        // this is the recommended way for registering Drivers
        Driver d = (Driver)Class.forName("solid.jdbc.SolidDriver").newInstance();

        System.out.println("Driver succesfully registered.");

        // the user is asked for a connect string 
        System.out.println("Now sample application needs a connectstring in format:\n");
        System.out.println("jdbc:solid://<host>:<port>/<user name>/<password>\n");
        System.out.print("\nPlease enter the connect string >");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String sCon = reader.readLine();

        // next, the connection is attempted
        System.out.println("Attempting to connect :" + sCon);
        conn = DriverManager.getConnection(sCon);

        System.out.println("SolidDriver succesfully connected.");

        DoIt();

        conn.close();
        // and now it is all over
        System.out.println("\nResult set dumped. Sample application finishes.");
    }


    static void DoIt() {
        try {
            createprocs();
            PreparedStatement pstmt = conn.prepareStatement("call sample3(?)");
            // set parameter value
            pstmt.setInt(1,10); 

            ResultSet rs = pstmt.executeQuery();
            if (rs != null) {
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                int row = 0;
                while (rs.next()) {
                    row++;
                    String ret = "row "+row+": ";
                    for (int i=1;i<=cols;i++) {
                        ret = ret + rs.getString(i) + " ";
                    }
                    System.out.println(ret);
                }
            }
            conn.commit();
        }
        catch (SQLException ex) {
            printexp(ex);
        }
        catch (java.lang.Exception ex) {
            ex.printStackTrace ();
        }

    }

    static void createprocs() {
        Statement stmt = null;
        String proc = "create procedure sample3 (limit integer)" +
                      "returns (c1 integer, c2 integer) " +
                      "begin " +
                      "  c1 := 0;" +
                      "  while c1 < limit loop " +
                      "    c2 := 5 * c1;" +
                      "    return row;" +
                      "    c1 := c1 + 1;" +
                      "  end loop;" +
                      "end";

        try {
            stmt = conn.createStatement();
            stmt.execute("drop procedure sample3");
        } catch (SQLException ex) {
            printexp(ex);
        }

        try {
            stmt.execute(proc);
        } catch (SQLException ex) {
            printexp(ex);
            System.exit(-1);
        }
    }

    public static void printexp(SQLException ex) {
        System.out.println("\n*** SQLException caught ***");
        while (ex != null) {
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("Message:  " + ex.getMessage());
            System.out.println("Vendor:   " + ex.getErrorCode());
            ex = ex.getNextException ();
        }
    }

}
