/****************************txt2vrml.c*********************************/
/*  This program is written as a part of the "Cryptogram" project by   */ 
/*  Zoltan Szegedy-Maszak. If you create your own key from a 3D object */
/*  by reducing its vertices to 256, and save it to a text file, with  */
/*  the "txt2vrml" program you can encrypt any text file to virtual    */
/*  "sculptures" (Cryptograms). You can use this program to decode any */
/*  text from Cryptograms.                                             */
/*  The "keyfile" must be in pure ascii format, the vertex points      */
/*  should be separated with newline characters, and the X, Y          */
/*  and Z coordinates of each point with spaces. (See the cavalier.txt */
/*  file for reference.)                                               */
/*  The program needs 3 arguments: the keyfile, the wrl-file to be     */
/*  decoded, and the filneme of the output (text-) filename.          */
/*  Example: txt2vrml key.txt message.wrl message.txt, where "key.txt" */
/*  is the filename (with full path if not located in the same         */
/*  directory) of the keyfile with the vertices, "message.wrl" (with   */
/*  full path if not located in the same directory) is the filename    */
/*  of the "sculpture" to be decoded and "message.txt" is the output.  */
/*                          *************                              */
/*  Created: 20-02-1996 Last modified: 29-04-1996                      */
/*  Author: Zoltan Szegedy-Maszak                                      */

#define _MAX_PATH   255
#define EOL   '\n'

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

FILE *fopen(), *keyfile, *textfile, *vrmlfile;

char line[64];
char vert[256][64];
static char vfile[_MAX_PATH], infile[_MAX_PATH], outfile[_MAX_PATH];

int i;
void set_up_points();
void decode();

void main(int argc, char *argv[])
{
	if(argc!=4)
		{ 
		fprintf(stderr,"error: missing or wrong arguments\n\nusage: \n vrml2txt keyfilename textfilename wrlfilename");
			exit(1);
		}

    strcpy(vfile,argv[1]);
    strcpy(infile,argv[2]);
    strcpy(outfile,argv[3]);

    printf("keyfile: %s inputfile: %s outputfile: %s\n\nplease wait...\n\n",vfile,infile,outfile);
	
	set_up_points();
    decode();
    
    printf("\nAll done...");
    exit( 0 );
}
 
void decode()
{
char *str =    " 	 	 	point [", *str2 =" 	 	 	 	]";
char c=0;


	if ((vrmlfile=fopen(infile,"r+t"))==NULL)
			{
			fprintf(stderr,"error opening keyfile: %s",vfile );
			exit(1);
		    }		
	if ((textfile=fopen(outfile,"w"))==NULL)
			{
			fprintf(stderr,"error opening outputfile: %s",outfile);
			exit(1);
		    }
		do
		{
		fgets(line,64,vrmlfile);
		if(strstr( line, str ))	break;
        }while(!strstr(line,"EOF"));            

		do
			{
		fgets(line,64,vrmlfile);                 

				for(i=0;i<256;i++)
					{
					if(strstr(line,vert[i]))
							{
							printf("%c",i);
							fprintf(textfile,"%c",i);
							break;
							}
					}
			}while(!strstr(line, str2));		

    fclose(textfile);
    fclose(vrmlfile);        
}

void  set_up_points()
{  
	char tmp[64]="";
	
	if ((keyfile=fopen(vfile,"rt"))==NULL)
			{
			fprintf(stderr,"error opening keyfile: %s",vfile );
			exit(1);
		    }
 
		for(i=0;i<256;i++)
		{
		fgets(tmp,64,keyfile);              /*reading lines and*/
		strncpy(vert[i],tmp,strlen(tmp)-1);	/*removing newlines*/	
		}             
    fclose(keyfile);        

}
