/****************************txt2vrml.c*********************************/
/*  This program is written as a part of the "Cryptogram" project by   */ 
/*  Zoltan Szegedy-Maszak. If you create your own key from a 3D object */
/*  by reducing its vertices to 256, and save it to a text file, with  */
/*  this program you can encrypt any text file to virtual "sculptures" */
/*  (Cryptograms). To decode the encrypted text one has to have your   */
/*  "key-file", and the program "vrml2txt".                                      */
/*  The "keyfile" must be in pure ascii format, the vertex points      */
/*  should be separated with newline characters, and the X, Y          */
/*  and Z coordinates of each point with spaces. (See the cavalier.txt */
/*  file for reference.)                                               */
/*  The program needs 3 arguments: the keyfile, the textfile to be     */
/*  encrypted, and the filneme of the output (vrml-) filename.         */
/*  Example: txt2vrml key.txt message.txt message.wrl, where "key.txt" */
/*  is the filename (with full path if not located in the same         */
/*  directory) of the keyfile with the vertices, "message.txt" (with   */
/*  full path if not located in the same directory) containing the     */
/*  text to be encrypted and "message.wrl" is the output-file.         */
/*                          *************                              */
/*  Created: 20-02-1996 Last modified: 29-04-1996                      */
/*  Author: Zoltan Szegedy-Maszak                                      */


#define _MAX_PATH   255
#define EOL   '\n'

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>


FILE *fopen(), *keyfile, *textfile, *vrmlfile;
int i;
char vert[256][64];
static char vfile[_MAX_PATH], infile[_MAX_PATH], outfile[_MAX_PATH];

void set_up_points();
void write_vrmlfile();	

void main(int argc, char *argv[])
{
	if(argc!=4)
		{ 
		fprintf(stderr,"error: missing or wrong arguments\n\nusage: \n txt2vrml <keyfilename> <textfilename> <wrlfilename>\n");
		fprintf(stderr,"example: txt2vrml key.txt message.txt message.wrl");
			exit(1);
		}
		
    strcpy(vfile,argv[1]);
    strcpy(infile,argv[2]);
    strcpy(outfile,argv[3]);

    printf("keyfile: %s inputfile: %s outputfile: %s\n\nplease wait, encrypting...\n\n",vfile,infile,outfile);
	
	set_up_points();
	write_vrmlfile();

    exit( 0 );

}

void write_vrmlfile()	
{
	char c=0;
	int numvertex;

	if ((textfile=fopen(infile,"r"))==NULL)
			{
			fprintf(stderr,"error opening inputfile: %s",infile );
			exit(1);
		    }
	if ((vrmlfile=fopen(outfile,"w"))==NULL)
			{
			fprintf(stderr,"error opening outputfile: %s",outfile);
			exit(1);
		    }


	fprintf(vrmlfile,"#VRML V1.0 ascii\n");
	fprintf(vrmlfile,"\n");		    
	fprintf(vrmlfile,"Separator { \n");		    
	fprintf(vrmlfile," \tDirectionalLight{ \n");		    
	fprintf(vrmlfile," \t \tdirection 0 0 -1 \n");		    
	fprintf(vrmlfile," \t \t \t} \n");		    
	fprintf(vrmlfile," \tDirectionalLight{ \n");		    
	fprintf(vrmlfile," \t \tdirection 0 0 1 \n");		    
	fprintf(vrmlfile," \t \t \t} \n");
	fprintf(vrmlfile,"\n");		    
	fprintf(vrmlfile,"PerspectiveCamera { \n");		    
	fprintf(vrmlfile," \t \tposition 0 3 600 \n");		    
	fprintf(vrmlfile," \t \torientation 0 0 1 0 \n");		    
	fprintf(vrmlfile," \t \tfocalDistance 10 \n");		    
	fprintf(vrmlfile," \t \theightAngle 0.78 \n");	    
	fprintf(vrmlfile," \t \t} \n");		    
	fprintf(vrmlfile,"\n");		    
	fprintf(vrmlfile," \tSeparator { \n");		    
	fprintf(vrmlfile," \t \tCoordinate3 { \n");		    
	fprintf(vrmlfile," \t \t \tpoint [ \n \t \t \t \t");		    
    numvertex=0;

/***********************************points********************************/
	do
	    {
		if (numvertex!=0) fprintf(vrmlfile," , \n \t \t \t \t");
		c=getc(textfile);
		i=__toascii(c);
		numvertex=numvertex + 1;
		fprintf(vrmlfile," %s",vert[i]);
	    }
	while(c!=EOF);
		
	fprintf(vrmlfile,"\n \t \t \t \t]\n");
	
	fprintf(vrmlfile,"} \n");
	fprintf(vrmlfile,"\n");


/**********************************facets********************************/

	fprintf(vrmlfile," \tIndexedFaceSet {\n");		    
	fprintf(vrmlfile," \t \tcoordIndex [ \n");		    
for (i=0;i<(numvertex-2);i++)
		fprintf(vrmlfile,"\t \t \t \t %d, %d, %d, -1, \n",i,i+1,i+2);		    
	fprintf(vrmlfile," \t \t \t \t%d, %d, %d, -1 \n",i,i+1,i+2);		    
	fprintf(vrmlfile," \t \t \t \t]\n");		    
	fprintf(vrmlfile," \t \t \t}\n");		    
	fprintf(vrmlfile," \t \t}\n");		    
	fprintf(vrmlfile,"}\n");
	
    fclose(textfile);
    fclose(vrmlfile);        
}

void  set_up_points()
{  
	char tmp[64]="";

	if ((keyfile=fopen(vfile,"rt"))==NULL)
			{
			fprintf(stderr,"error opening keyfile: %s",vfile );
			exit(1);
		    }
 
		for(i=0;i<256;i++)
		{
		fgets(tmp,64,keyfile);              /*reading lines*/
		
		strncpy(vert[i],tmp,strlen(tmp)-1);	/*and removing newlines*/	
		}             
    fclose(keyfile);        

}
